#!/bin/bash
export datasets="wikics cs"
# export missing_rates="0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.99 0.99 0.999 0.9999 1.0"
export missing_rates="0.0 0.1 0.9999 1.0"
export lambda_list_1="0.00001"
export lambda_list_2="0.00001 0.0001 0.001 0.01 0.1 1 1"
export lp_alpha_list="0.99 0.99 0.999 0.9999"
export embedders="GNN"
export embedder_lp_list="GCN_LPA Correct_Smooth"
export gpu=0

for missing_rate in $missing_rates
do
python main.py --dataset wikics --missing_rate ${missing_rate} --embedder GOODIE_attn --attn_type random --lp_alpha 0.9 --lamb 0 --n_runs 10 --missing_type uniform --gpu ${gpu}
python main.py --dataset wikics --missing_rate ${missing_rate} --embedder GOODIE_attn --attn_type sum --lp_alpha 0.9 --lamb 0 --n_runs 10 --missing_type uniform --gpu ${gpu}
python main.py --dataset wikics --missing_rate ${missing_rate} --embedder GOODIE_attn --attn_type mean --lp_alpha 0.9 --lamb 0 --n_runs 10 --missing_type uniform --gpu ${gpu}
python main.py --dataset wikics --missing_rate ${missing_rate} --embedder GOODIE_attn --attn_type concat --lp_alpha 0.9 --lamb 0 --n_runs 10 --missing_type uniform --gpu ${gpu}
done

for missing_rate in $missing_rates
do
python main.py --dataset wikics --missing_rate ${missing_rate} --embedder GOODIE_attn --attn_type random --lp_alpha 0.9 --lamb 0 --n_runs 10 --missing_type structural --gpu ${gpu}
python main.py --dataset wikics --missing_rate ${missing_rate} --embedder GOODIE_attn --attn_type sum --lp_alpha 0.9 --lamb 0 --n_runs 10 --missing_type structural --gpu ${gpu}
python main.py --dataset wikics --missing_rate ${missing_rate} --embedder GOODIE_attn --attn_type mean --lp_alpha 0.9 --lamb 0 --n_runs 10 --missing_type structural --gpu ${gpu}
python main.py --dataset wikics --missing_rate ${missing_rate} --embedder GOODIE_attn --attn_type concat --lp_alpha 0.9 --lamb 0 --n_runs 10 --missing_type structural --gpu ${gpu}
done
